<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2020-11-11 22:19
 */
interface TypesupplierDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Typesupplier 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param typesupplier primary key
 	 */
	public function delete($typeId);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Typesupplier typesupplier
 	 */
	public function insert($typesupplier);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Typesupplier typesupplier
 	 */
	public function update($typesupplier);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByTypeName($value);

	public function queryByConditions($value);

	public function queryByComments($value);

	public function queryByTypeDate($value);


	public function deleteByTypeName($value);

	public function deleteByConditions($value);

	public function deleteByComments($value);

	public function deleteByTypeDate($value);


}
?>